
#library packages
library(dplyr)
library(ggplot2)

setwd("D:\\metabolism\\LGG\\11.clinical\\1.clusterClipie")     
dat <- read.table("input.txt",row.names = 1,sep = "\t",header = T,check.names = F,stringsAsFactors = F)

gname <- "group"
vname <- setdiff(colnames(dat), gname)
pie.high <- pie.low <- list()
fisher.p <- c()
for (i in vname) {
  tmp <- table(dat[,gname], dat[,i])
  p <- format(fisher.test(tmp)$p.value,digits = 2)
  names(p) <- i
  fisher.p <- c(fisher.p, p)
  
  pie.dat <- 
    tmp %>% as.data.frame() %>% group_by(Var1) %>% mutate(Pct = Freq/sum(Freq)) %>% as.data.frame()
  pie.high[[i]] <- pie.dat[which(pie.dat$Var1 == "C1"),]
  pie.low[[i]] <- pie.dat[which(pie.dat$Var1 == "C2"),]
}

# ɫ
brown  <- "#A77D06"
blue   <- "#3C4E98"
yellow <- "#E4DB36"
orange <- "#E19143"
green  <- "#57A12B"
cherry <- "#8D3A86"
grey <- "#8A8A8A"

# ɫ
grade.col <- c(alpha(green, c(0.5, 1)),grey)
death.col <- c(alpha(blue, c(0.5, 1)))
gender.col <- c(yellow, orange)
age.col <- c(alpha(brown, c(0.5, 1)))
Histological.col <- c(alpha(cherry, c(0.5, 0.7, 1)))

# Ӳbase plotһһ黭ȻҲ԰еpie chartȡAIPPTƴҲǱȽϷ
pdf("pieTable.pdf",width = 7, height = 5)
showLayout <- F # ĬϲpdfҳʾlayoutṹλƵʱΪTRUEһ£

# û沼ִ֣ͬͬһ飬ԽռԽһ25
layout(matrix(c( 1, 1, 1,  2, 2, 2,  3, 3, 3,  4, 4, 4,  5, 5, 5,  6, 6, 6,
                 7, 7, 7,  8, 8, 8,  9, 9, 9, 10,10,10, 11,11,11, 12,12,12,
                 7, 7, 7,  8, 8, 8,  9, 9, 9, 10,10,10, 11,11,11, 12,12,12,
                 13,13,13, 14,14,14, 15,15,15, 16,16,16, 17,17,17, 18,18,18,
                 13,13,13, 14,14,14, 15,15,15, 16,16,16, 17,17,17, 18,18,18,
                 19,19,19, 20,20,20, 21,21,21, 22,22,22, 23,23,23, 24,24,24,
                 25,25,25, 25,25,25, 25,25,25, 25,25,25, 25,25,25, 25,25,25),
              byrow = T,nrow = 7))

if(showLayout) {
  layout.show(n = 25) # ֱչʾֲ
}

#-------------------------#
# 1-6ͼ̧ͷ #
#-------------------------#

par(bty="n", mgp = c(0,0,0), mar = c(0,0,0,0), lwd = 2) # ߽Ϊ0
plot(1,1,
     xlab = "",xaxt = "n", # ʾx
     ylab = "",yaxt = "n") # ʾy
rect(par("usr")[1],par("usr")[3],par("usr")[2],par("usr")[4],col = "black") # Ϳ
text((par("usr")[1]+par("usr")[2])/2, # par("usr")ȡûľλ
     (par("usr")[3]+par("usr")[4])/2,
     "metabolismcluster",cex = 2, col = "white") # ʾͼ

plot(1,1,
     xlab = "",xaxt = "n", # ʾx
     ylab = "",yaxt = "n") # ʾy
rect(par("usr")[1],par("usr")[3],par("usr")[2],par("usr")[4],col = "black") # Ϳ
text((par("usr")[1]+par("usr")[2])/2, # par("usr")ȡûľλ
     (par("usr")[3]+par("usr")[4])/2,
     "Grade",cex = 2, col = "white") # ʾͼ

plot(1,1,
     xlab = "",xaxt = "n", # ʾx
     ylab = "",yaxt = "n") # ʾy
rect(par("usr")[1],par("usr")[3],par("usr")[2],par("usr")[4],col = "black") # Ϳ
text((par("usr")[1]+par("usr")[2])/2, # par("usr")ȡûľλ
     (par("usr")[3]+par("usr")[4])/2,
     "Death",cex = 2, col = "white") # ʾͼ

plot(1,1,
     xlab = "",xaxt = "n", # ʾx
     ylab = "",yaxt = "n") # ʾy
rect(par("usr")[1],par("usr")[3],par("usr")[2],par("usr")[4],col = "black") # Ϳ
text((par("usr")[1]+par("usr")[2])/2, # par("usr")ȡûľλ
     (par("usr")[3]+par("usr")[4])/2,
     "Gender",cex = 2, col = "white") # ʾͼ

plot(1,1,
     xlab = "",xaxt = "n", # ʾx
     ylab = "",yaxt = "n") # ʾy
rect(par("usr")[1],par("usr")[3],par("usr")[2],par("usr")[4],col = "black") # Ϳ
text((par("usr")[1]+par("usr")[2])/2, # par("usr")ȡûľλ
     (par("usr")[3]+par("usr")[4])/2,
     "Age",cex = 2, col = "white") # ʾͼ

plot(1,1,
     xlab = "",xaxt = "n", # ʾx
     ylab = "",yaxt = "n") # ʾy
rect(par("usr")[1],par("usr")[3],par("usr")[2],par("usr")[4],col = "black") # Ϳ
text((par("usr")[1]+par("usr")[2])/2, # par("usr")ȡûľλ
     (par("usr")[3]+par("usr")[4])/2,
     "Histological",cex = 2, col = "white") # ʾͼ


plot(1,1,
     xlab = "",xaxt = "n", # ʾx
     ylab = "",yaxt = "n") # ʾy
rect(par("usr")[1],par("usr")[3],par("usr")[2],par("usr")[4],col = "black") # Ϳ
text((par("usr")[1]+par("usr")[2])/2, # par("usr")ȡûľλ
     (par("usr")[3]+par("usr")[4])/2,
     "C1\n(n = 423)",cex = 2, col = "white") # ʾͼ

# C1 group
pie(pie.high$Grade$Pct, 
    col = grade.col, 
    border = "white",  
    radius = 1, 
    labels = NA,
    init.angle = 90)
symbols(0,0, circles = .55, inches = FALSE, col = "white", bg = "white", lty = 0, add = TRUE)

pie(pie.high$Death$Pct, 
    col = death.col, 
    border = "white",  
    radius = 1, 
    labels = NA,
    init.angle = 90)
symbols(0,0, circles = .55, inches = FALSE, col = "white", bg = "white", lty = 0, add = TRUE)

pie(pie.high$Gender$Pct, 
    col = gender.col, 
    border = "white",  
    radius = 1, 
    labels = NA,
    init.angle = 90)
symbols(0,0, circles = .55, inches = FALSE, col = "white", bg = "white", lty = 0, add = TRUE)

pie(pie.high$Age$Pct, 
    col = age.col, 
    border = "white",  
    radius = 1, 
    labels = NA,
    init.angle = 90)
symbols(0,0, circles = .55, inches = FALSE, col = "white", bg = "white", lty = 0, add = TRUE)

pie(pie.high$Histological$Pct, 
    col = Histological.col, 
    border = "white",  
    radius = 1, 
    labels = NA,
    init.angle = 90)
symbols(0,0, circles = .55, inches = FALSE, col = "white", bg = "white", lty = 0, add = TRUE)
abline(v = par("usr")[2], col = "black") # ҲϺ


plot(1,1,
     xlab = "",xaxt = "n", # ʾx
     ylab = "",yaxt = "n") # ʾy
rect(par("usr")[1],par("usr")[3],par("usr")[2],par("usr")[4],col = "black") # Ϳ
text((par("usr")[1]+par("usr")[2])/2, # par("usr")ȡûľλ
     (par("usr")[3]+par("usr")[4])/2,
     "C2\n(n = 83)",cex = 2, col = "white") # ʾͼ

# C2 group
pie(pie.low$Grade$Pct, 
    col = grade.col, 
    border = "white",  
    radius = 1, 
    labels = NA,
    init.angle = 90)
symbols(0,0, circles = .55, inches = FALSE, col = "white", bg = "white", lty = 0, add = TRUE)

pie(pie.low$Death$Pct, 
    col = death.col, 
    border = "white",  
    radius = 1, 
    labels = NA,
    init.angle = 90)
symbols(0,0, circles = .55, inches = FALSE, col = "white", bg = "white", lty = 0, add = TRUE)

pie(pie.low$Gender$Pct, 
    col = gender.col, 
    border = "white",  
    radius = 1, 
    labels = NA,
    init.angle = 90)
symbols(0,0, circles = .55, inches = FALSE, col = "white", bg = "white", lty = 0, add = TRUE)

pie(pie.low$Age$Pct, 
    col = age.col, 
    border = "white",  
    radius = 1, 
    labels = NA,
    init.angle = 90)
symbols(0,0, circles = .55, inches = FALSE, col = "white", bg = "white", lty = 0, add = TRUE)

pie(pie.low$Histological$Pct, 
    col = Histological.col, 
    border = "white",  
    radius = 1, 
    labels = NA,
    init.angle = 90)
symbols(0,0, circles = .55, inches = FALSE, col = "white", bg = "white", lty = 0, add = TRUE)
abline(v = par("usr")[2], col = "black") # ҲϺ


plot(1,1,
     xlab = "",xaxt = "n", # ʾx
     ylab = "",yaxt = "n") # ʾy
rect(par("usr")[1],par("usr")[3],par("usr")[2],par("usr")[4],col = "black") # Ϳ

plot(1,1,col = "white",
     xlab = "",xaxt = "n", # ʾx
     ylab = "",yaxt = "n") # ʾy
text((par("usr")[1]+par("usr")[2])/2, # par("usr")ȡûľλ
     (par("usr")[3]+par("usr")[4])/2,
     paste0("p = ",fisher.p["Grade"]),cex = 1.5, col = "black") # ʾͼ
abline(h = par("usr")[3], col = "black") # ײϺ

plot(1,1,col = "white",
     xlab = "",xaxt = "n", # ʾx
     ylab = "",yaxt = "n") # ʾy
text((par("usr")[1]+par("usr")[2])/2, # par("usr")ȡûľλ
     (par("usr")[3]+par("usr")[4])/2,
     paste0("p = ",fisher.p["Stage"]),cex = 1.5, col = "black") # ʾͼ
abline(h = par("usr")[3], col = "black")

plot(1,1,col = "white",
     xlab = "",xaxt = "n",# ʾx
     ylab = "",yaxt = "n") # ʾy
text((par("usr")[1]+par("usr")[2])/2, # par("usr")ȡûľλ
     (par("usr")[3]+par("usr")[4])/2,
     paste0("p = ",fisher.p["BMI"]),cex = 1.5, col = "black") # ʾͼ
abline(h = par("usr")[3], col = "black")

plot(1,1,col = "white",
     xlab = "",xaxt = "n", # ʾx
     ylab = "",yaxt = "n") # ʾy
text((par("usr")[1]+par("usr")[2])/2, # par("usr")ȡûľλ
     (par("usr")[3]+par("usr")[4])/2,
     paste0("p = ",fisher.p["Age"]),cex = 1.5, col = "black") # ʾͼ
abline(h = par("usr")[3], col = "black")

plot(1,1,col = "white",
     xlab = "",xaxt = "n", # ʾx
     ylab = "",yaxt = "n") # ʾy
text((par("usr")[1]+par("usr")[2])/2, # par("usr")ȡûľλ
     (par("usr")[3]+par("usr")[4])/2,
     paste0("p = ",fisher.p["Histological"]),cex = 1.5, col = "black") # ʾͼ
abline(h = par("usr")[3], col = "black") # ײϺ
abline(v = par("usr")[2], col = "black") # ҲϺ



plot(0,0,col = "white",
     xlab = "",xaxt = "n", # ʾx
     ylab = "",yaxt = "n") # ʾy
legend("topleft",
       legend = c("G2","G3","unknow",
                  "No","Yes",
                  "FEMALE","MALE",
                  "40",">40",
                  "Astrocytoma","Oligoastrocytoma","Oligodendroglioma"),
       fill = c(grade.col,
                death.col,
                gender.col,
                age.col,
                Histological.col),
       border = NA, # ͼɫûб߿
       bty = "n", # ͼûб߿
       cex = 1.2,
       #box.lwd = 3,
       x.intersp = 0.05,
       y.intersp = 1,
       text.width = 0.075, # ͼļ
       horiz = T) # ͼˮƽ

# رͼ
invisible(dev.off())
